Rem
Rem ordplsci.sql
Rem
Rem Copyright (c) 2001, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      ordplsci.sql - Oracle Multimedia Code Wizard installation script.
Rem
Rem    DESCRIPTION
Rem      Installs the Oracle Multimedia Code Wizard for the PL/SQL Gateway.
Rem
Rem    NOTES
Rem      You must connect as SYSTEM prior to running this script.
Rem

spool ordplsci

-- query for username of code wizard admin
accept cwadmin char format a30 prompt "Enter the authorized admin user for the code wizard: "

-- check user name
WHENEVER SQLERROR EXIT;
ALTER SESSION SET CURRENT_SCHEMA="&cwadmin";

-- install in ORDSYS
WHENEVER SQLERROR CONTINUE;
ALTER SESSION SET CURRENT_SCHEMA="ORDSYS";

-- Create code wizard package
@@ordplscw.sql

-- Grant execute permission and create public synonym
GRANT EXECUTE ON ORDSYS.OrdPlsGwyCodeWizard TO PUBLIC;
CREATE OR REPLACE PUBLIC SYNONYM OrdCWPkg FOR ORDSYS.OrdPlsGwyCodeWizard;

-- Migrate authorized DADs from ORDSYS to cwadmin
WHENEVER SQLERROR EXIT;
ALTER SESSION SET CURRENT_SCHEMA="&cwadmin";
@@ordcwmig.sql
set serveroutput on;
CALL Ordplsgwymigrate.migrate_authed_dads();
DROP PACKAGE Ordplsgwymigrate;

spool off;
exit;
